/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "TextEditProperties.h"
#include "TextEdit.h"

namespace SciFigs {

TextEditProperties::TextEditProperties(QWidget * parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  addProperty(TextAsData, textAsData, textAsData);
  addProperty(Text, text, textLabel);
  addProperty(Font, text, fontLabel);
  addProperty(AdjustBox, adjustBox);
}

PropertyValue::WidgetType TextEditProperties::determineCustomWidgetType(int pid, QWidget *, QWidget * )
{
  TRACE;
  if(pid==Font) {
    return PropertyValue::Custom0;
  } else {
    return PropertyValue::Unknown;
  }
}

bool TextEditProperties::connectCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return true;
  } else {
    return false;
  }
}

bool TextEditProperties::setCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    QFont f;
    if(f.fromString(p.value().toString()) ) {
      static_cast<QTextEdit *>(p.widget())->setFont(f);
    }
    return true;
  } else {
    return false;
  }
}

QVariant TextEditProperties::customWidgetValue(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return static_cast<QTextEdit *>(p.widget())->font().toString();
  } else {
    return QVariant();
  }
}

void TextEditProperties::on_fontBut_clicked()
{
  TRACE;
  bool ok;
  QFont f=QFontDialog::getFont(&ok, text->font(), this);
  if(ok) {
    text->blockSignals(true);
    text->setFont(f);
    text->setPlainText(text->toPlainText());
    text->blockSignals(false);
    propertyValue(Font)->touched();
  }
}

} // namespace SciFigs
