/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-08-01
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SELECTIONWIDGET_H
#define SELECTIONWIDGET_H

#include "GraphicObject.h"

namespace SciFigs {

#define SEL_WEIGHT 3

class SelectionWidget :  public QWidget
{
  Q_OBJECT
public:
  SelectionWidget(GraphicObject*, QWidget * parent=nullptr);
  ~SelectionWidget();

  enum State {Hoover, Selected, Activated};
  GraphicObject * widget () {return _widget;}
  int x(int xObj) {return xObj-SEL_WEIGHT;}
  int y(int yObj) {return yObj-SEL_WEIGHT;}
  int width() {return _widget->width()+SEL_WEIGHT*2;}
  int height() {return _widget->height()+SEL_WEIGHT*2;}
  State state() {return _state;}
  void setState(State s) {_state=s;update();}
protected:
  GraphicObject * _widget;
  State _state;
  virtual void paintEvent(QPaintEvent * );
  virtual void mousePressEvent (QMouseEvent * e);
  virtual void mouseReleaseEvent (QMouseEvent * e);
  virtual void mouseMoveEvent (QMouseEvent * e);
  virtual void mouseDoubleClickEvent (QMouseEvent * e);
  virtual void leaveEvent (QEvent * e);
};

} // namespace SciFigs

#endif // SELECTIONWIDGET_H
