/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SCIFIGSGLOBAL_H
#define SCIFIGSGLOBAL_H

#include <QtGui>
#include <QGpGuiTools.h>
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT SciFigsGlobal : public GlobalObject
  {
  public:
    SciFigsGlobal();
    ~SciFigsGlobal();

    static bool isInitialized() {return _screenResolution > 0.0;}
    static double screenResolution() {return _screenResolution;}

    static void footprint(QPainter& p, double dotpercm, int w, int h);
    static void initPlugins(bool debug);

    static QBitmap colorMask(const QPixmap& pixmap, uint blankColor);
  private:
    static double _screenResolution;
  };

  class SCIFIGS_EXPORT SciFigsPluginSettings : public PluginSettings
  {
  public:
    SciFigsPluginSettings();
  };

} // namespace SciFigs

#endif // SCIFIGSGLOBAL_H
