/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PLOTLINE2D_H
#define PLOTLINE2D_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT PlotLine2D : public AbstractLine
{
  TRANSLATIONS("PlotLine2D")
public:
  virtual AbstractLine * clone() const;
  virtual void operator=(const PlotLine2D& o);

  virtual int count() const {return _curve.count();}
  virtual void clear() {_curve.clear();}
  virtual void append() {_curve.append(Point2D());}
  virtual void insert(int index) {_curve.insert(index, Point2D());}
  virtual void removeLast() {_curve.remove(_curve.count()-1);}
  virtual bool isSorted() const {return _curve.isSorted();}
  virtual void checkSort() {_curve.checkSort();}
  virtual void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  virtual Point point(int index, const CurvePointOptions *) const {return _curve.at(index);}
  virtual void setX(int index, double v) {_curve[index].setX(v);}
  virtual void setY(int index, double v, const CurvePointOptions *) {_curve[index].setY(v);}
  virtual void setZ(int, double, const CurvePointOptions *) {}

  const Curve<Point2D>& curve() const {return _curve;}
  Curve<Point2D>& curve() {return _curve;}
  void setCurve(const Curve<Point2D>& curve);
  void setCurve(const Curve<Point2D>& curve, const Pen& pen, const Symbol& sym);
  void setCurve(QVector<double> * dataX, QVector<double> * dataY);
protected:
  Curve<Point2D> _curve;
};

} // namespace SciFigs

#endif // PLOTLINE2D.H
