/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINEITEM_H
#define LINEITEM_H

#include <QtGui>
#include "SciFigsDLLExport.h"

namespace SciFigs {

class LineLayer;
class AbstractLine;

class SCIFIGS_EXPORT LineItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  LineItem(QObject * parent=nullptr);
  ~LineItem() {}

  void setLine(LineLayer * layer, AbstractLine * line);
  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual Qt::ItemFlags flags (const QModelIndex & ) const;
private:
  LineLayer * _layer;
  AbstractLine * _line;
};

} // namespace SciFigs

#endif // LINEITEM_H
