/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-01
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDITEMWIDGET_H
#define LEGENDITEMWIDGET_H

#include "GraphicObject.h"
#include "SciFigsDLLExport.h"
#include "LegendItem.h"

namespace SciFigs {

class SCIFIGS_EXPORT LegendItemDisplay : public LegendItem
{
public:
  LegendItemDisplay();
  LegendItemDisplay(const LegendItem& o);
  ~LegendItemDisplay() {}

  void setDisplayText(bool b) {_displayText=b;}

  QSize sizeHint (const QFont& font) const;
  void paint(QPainter& p, double dotpercm, int x, int y, int w, int h) const;
protected:
  bool _displayText;
};

class SCIFIGS_EXPORT LegendItemWidget : public GraphicObject, public LegendItemDisplay
{
public:
  LegendItemWidget(QWidget *parent=nullptr);
  ~LegendItemWidget() {}

  virtual QSize sizeHint() const {return LegendItemDisplay::sizeHint(font());}
protected:
  virtual void paint(QPainter& p, double dotpercm, int w, int h, bool mask);
  virtual void paintEvent(QPaintEvent * e);
};

} // namespace SciFigs

#endif // LEGENDITEMWIDGET_H
