/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-27
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LegendFormatProperties.h"
#include "LegendWidget.h"

namespace SciFigs {

/*!
  \class LegendProperties LegendProperties.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
LegendFormatProperties::LegendFormatProperties(QWidget * parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  addProperty(Title, title, titleLabel);
  addProperty(Font, title, fontLabel);
  addProperty(LineSize, lineSize, lineSizeLabel);
  addProperty(AdjustBox, adjustBox);
}

PropertyValue::WidgetType LegendFormatProperties::determineCustomWidgetType(int pid, QWidget *, QWidget * )
{
  TRACE;
  if(pid==Font) {
    return PropertyValue::Custom0;
  } else {
    return PropertyValue::Unknown;
  }
}

bool LegendFormatProperties::connectCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return true;
  } else {
    return false;
  }
}

bool LegendFormatProperties::setCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    QFont f;
    if(f.fromString(p.value().toString()) ) {
      static_cast<QTextEdit *>(p.widget())->setFont(f);
    }
    return true;
  } else {
    return false;
  }
}

QVariant LegendFormatProperties::customWidgetValue(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return static_cast<QTextEdit *>(p.widget())->font().toString();
  } else {
    return QVariant();
  }
}

void LegendFormatProperties::on_fontBut_clicked()
{
  TRACE;
  bool ok;
  QFont font=QFontDialog::getFont(&ok, title->font(), this);
  if(ok) {
    title->setFont(font);
    title->blockSignals(true);
    title->setPlainText(title->toPlainText());
    title->blockSignals(false);
    propertyValue(Font)->touched();
  }
}

} // namespace SciFigs
