/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GridMaxFollower.h"
#include "IrregularGrid2DPlot.h"
#include "LineLayerProperties.h"
#include "PlotLine2D.h"

namespace SciFigs {

/*!
  \class GridMaxFollower GridMaxFollower.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GridMaxFollower::GridMaxFollower(IrregularGrid2DPlot * grid, AxisType axis)
    : LineLayer(grid->graph())
{
  TRACE;
  PlotLine2D * ref=new PlotLine2D;
  ref->setPen(Pen( Qt::black, 0.6) );
  ref->setSymbol(Symbol( Symbol::Circle, 1.2, Pen(Qt::black, 0.0),
                             Brush(Qt::black, Qt::SolidPattern) ));
  setReferenceLine(ref);
  _grid=grid;
  _axis=axis;
}

void GridMaxFollower::addProperties(PropertyProxy * pp)
{
  TRACE;
  LineLayer::addProperties(pp);
  LineLayerProperties * w=static_cast<LineLayerProperties *>(pp->currentTabWidget());
  QAction * a=w->addLineAction(tr("&Adjust"), tr("Adjust current line to the closest maximum"));
  connect(a, SIGNAL(triggered()), this, SLOT(adjustLine()) );
}

void GridMaxFollower::adjustLine()
{
  TRACE;
#if 0
  ASSERT(_propertiesTab);
  if(_propertiesTab->currentLayer()!=this) return;

  DynLine2D * l=line(_propertiesTab->currentLine());
  Curve<Point2D>& c=*l->curve();
  const IrregularGrid2D * grid=_grid->grid();

  lockDelayPainting();
  switch(_axis) {
  case IrregularGrid2D::X_Axis:
    c.setFunction();
    grid->followMaximumX< Curve<Point2D>, Point2D >(c, -std::numeric_limits<double>::infinity(), std::numeric_limits<double>::infinity());
    break;
  case IrregularGrid2D::Y_Axis:
    c.swapXY();
    c.setFunction();
    grid->followMaximumY< Curve<Point2D>, Point2D >(c, -std::numeric_limits<double>::infinity(), std::numeric_limits<double>::infinity());
    c.swapXY();
    break;
  }
  unlock();

  _propertiesTab->updateCurrentLine();
  deepUpdate();
#endif
}

} // namespace SciFigs
