/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-21
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MagnetoTelluricPlotProxy.h"
#include "MagnetoTelluricLine.h"

namespace QGpGuiWave {

  /*!
    \class MagnetoTelluricPlotProxy MagnetoTelluricPlotProxy.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
  */
  void MagnetoTelluricPlotProxy::setXAxisProperties(Axis * a)
  {
    TRACE;
    a->setUnitFactor(1e-3);
    a->setScaleType(Scale::Log);
    a->setReversedScale(true);
    a->setAutoTicks(false);
    a->setMajorTicks(5.0);
    a->setMinorTicks(1.0);
    // Force title with multiplication for units
    a->setTitle("Frequency (kHz)");
    a->setTitleInversedScale("Period (ms)");
  }

  void MagnetoTelluricPlotProxy::setCurve(AbstractLine * line, CurveProxy * proxy)
  {
    TRACE;
    static_cast<MagnetoTelluricProxy *>(proxy)->setCurve(&static_cast<MagnetoTelluricLine *>(line)->curve());
  }

} // namespace QGpGuiWave
