/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYCATEGORYSETTINGS_H
#define PROPERTYCATEGORYSETTINGS_H

#include <QtCore>
#include <QGpCoreTools.h>
#include <time.h>

namespace QGpGuiTools {

class ExpandTabWidget;
class PropertyTabSettings;

class PropertyCategorySettings
{
public:
  PropertyCategorySettings();
  ~PropertyCategorySettings();

  void setState(unsigned int key, const QByteArray& s);
  void setScrollPosition(unsigned int key, int p);
  QByteArray state(unsigned int key);
  int scrollPosition(unsigned int key);

  void setClickTime(time_t t) {_clickTime=t;}
  void setClickTime() {_clickTime=time(0);}
  time_t clickTime() const {return _clickTime;}

  QStringList keys() const;
  QStringList scrollPositions() const;
  QList<QVariant> states() const;

  void set(const QStringList& keys, const QList<QVariant>& states, const QStringList& scrollPositions);
private:
  time_t _clickTime;
  QMap<uint, PropertyTabSettings> _tabSettings;
};

} // namespace QGpGuiTools

#endif // PROPERTYCATEGORYSETTINGS_H
