/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-10-21
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HTTPPROXYOBJECT_H
#define HTTPPROXYOBJECT_H

#include <QtCore>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT HttpProxyObject : public QObject
  {
    Q_OBJECT
  public:
    HttpProxyObject(QObject * parent=nullptr);
    ~HttpProxyObject();

    Q_INVOKABLE bool isPlainHostName(QString host);
    Q_INVOKABLE bool dnsDomainIs(QString host, QString domain);
    Q_INVOKABLE bool localHostOrDomainIs(QString host, QString hostDom);
    Q_INVOKABLE bool isResolvable(QString host);
    Q_INVOKABLE bool isInNet(QString host, QString pattern, QString mask);
    Q_INVOKABLE QString dnsResolve(QString host);
    Q_INVOKABLE QString myIpAddress();
    Q_INVOKABLE int dnsDomainLevels(QString host);
    Q_INVOKABLE bool shExpMatch(QString str, QString shexp);
    Q_INVOKABLE bool weekdayRange(QString wd1, QString wd2=QString(), QString gmt=QString());
    Q_INVOKABLE bool dateRange(QString day1, QString month1=QString(), QString year1=QString(),
                               QString day2=QString(), QString month2=QString(), QString year2=QString(),
                               QString gmt=QString());
    Q_INVOKABLE bool timeRange(QString hour1, QString min1=QString(), QString sec1=QString(),
                               QString hour2=QString(), QString min2=QString(), QString sec2=QString(),
                               QString gmt=QString());
  private:
    static bool inWeekdayRange(int day, const QString& wd1, const QString& wd2);
    static int monthIndex(const QString& mon);
  };

} // namespace QGpGuiTools

#endif // HTTPPROXYOBJECT_H

