﻿/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-11
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ColumnTextItem.h"

namespace QGpGuiTools {

/*!
  \class ColumnTextItem ColumnTextItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ColumnTextItem::ColumnTextItem(QObject * parent)
    : QAbstractItemModel(parent)
{
  TRACE;
  _parser=nullptr;
}

/*!
  Description of destructor still missing
*/
ColumnTextItem::~ColumnTextItem()
{
  TRACE;
}

void ColumnTextItem::setParser(ColumnTextParser * p)
{
  TRACE;
  _parser=p;
  if(p) {
    connect(p, SIGNAL(rowsAboutToBeParsed()), this, SLOT(rowsAboutToBeParsed()));
    connect(p, SIGNAL(rowsParsed()), this, SLOT(rowsParsed()));
  }
}

void ColumnTextItem::rowsAboutToBeParsed()
{
  TRACE;
  beginResetModel();
}

void ColumnTextItem::rowsParsed()
{
  TRACE;
  endResetModel();
}

int ColumnTextItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if(parent.isValid() || !_parser) {
    return 4;
  } else {
    return _parser->rowCount()+4;
  }
}

/*!
  Currently return only 1 but may evolve in the future
*/
int ColumnTextItem::columnCount(const QModelIndex & parent) const
{
  TRACE;
  if(parent.isValid() || !_parser) {
    return 0;
  } else {
    return _parser->columnCount();
  }
}

QVariant ColumnTextItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if( !index.isValid()) return QVariant();
  switch (role) {
  case Qt::DisplayRole:
    switch(index.row()) {
    case 0:
      return _parser->typeName(index.column());
    case 1:
      return _parser->factor(index.column());
    case 2:
      return _parser->replaceRx(index.column());
    case 3:
      return _parser->replaceAfter(index.column());
    default:
      return _parser->text(index.row()-4, index.column());
    }
  case Qt::ToolTipRole:
    switch(index.row()) {
    case 0:
      return tr("Associate columns to data fields");
    case 1:
      return tr("Factors to convert values shown below to the standard units");
    case 2:
    case 3:
      return tr("A 'Regular Expression' can be searched in cell contents and replaced\n"
                "See online documentation for more details.");
    default: {
        int row=index.row()-4;
        int sec=_parser->sectionIndexOf(row);
        if(_parser->sectionBeginRow(sec)==row) {
          return _parser->sectionComments(sec);
        } else {
          return QVariant();
        }
      }
    }
  case Qt::BackgroundRole:
    if(index.row()>=4) {
      int row=index.row()-4;
      int sec=_parser->sectionIndexOf(row);
      if(_parser->sectionBeginRow(sec)==row) {
        return QColor(200,200,200);
      } else {
        return QVariant();
      }
    } else {
      return QColor(239,239,239);
    }
  case Qt::TextAlignmentRole:
    if(index.row()>=2) {
      return QVariant();
    } else {
      return Qt::AlignHCenter;
    }
  default:
    return QVariant();
  }
}

bool ColumnTextItem::setData(const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  if(!index.isValid()) return false;
  if(role==Qt::EditRole) {
    switch(index.row()) {
    case 0:
      _parser->setTypeName(index.column(), value.toString());
      emit typeChanged();
      return true;
    case 1:
      _parser->stopUpdates();
      _parser->setFactor(index.column(), value.toDouble());
      _parser->startUpdates();
      return true;
    case 2:
      _parser->stopUpdates();
      _parser->setReplaceRx(index.column(), value.toString());
      _parser->startUpdates();
      return true;
    case 3:
      _parser->stopUpdates();
      _parser->setReplaceAfter(index.column(), value.toString());
      _parser->startUpdates();
      return true;
    default:
      return false;
    }
  } else {
    return false;
  }
}

QVariant ColumnTextItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  switch(orientation) {
  case Qt::Horizontal:
    return section+1;
  case Qt::Vertical:
    switch(section) {
    case 0:
      return tr("Type");
    case 1:
      return tr("Factor");
    case 2:
      return tr("Find");
    case 3:
      return tr("Replace");
    default:
      return _parser->lineNumber(section-4);
    }
  }
  return QVariant();
}

QModelIndex ColumnTextItem::parent (const QModelIndex & ) const
{
  TRACE;
  return QModelIndex();
}

QModelIndex ColumnTextItem::index (int row, int column, const QModelIndex & parent) const
{
  TRACE;
  if(!parent.isValid())
    return createIndex(row, column);
  else
    return QModelIndex();
}

Qt::ItemFlags ColumnTextItem::flags(const QModelIndex & index) const
{
  if(index.row()<4) {
    return Qt::ItemIsEnabled | Qt::ItemIsSelectable | Qt::ItemIsEditable;
  } else if(_parser->type(index.column())==0) {
    return Qt::NoItemFlags;
  } else {
    return Qt::ItemIsEnabled;
  }
}

} // namespace QGpGuiTools
