/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-25
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AutocorrRing.h"

namespace QGpCoreWave {

/*!
  \class AutocorrRing AutocorrRing.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString AutocorrRing::xmlAutocorrRingTag= "AutocorrRing";

/*!
  \fn AutocorrRing::AutocorrRing()
  Default constructor (init zero rings)
*/

/*!
  \fn AutocorrRing::AutocorrRing(double rMin, double rMax)
  Init a ring with minium (\a rMin) and maximum (\a rMax) radii
*/

void AutocorrRing::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "minRadius", _minRadius);
  writeProperty(s, "maxRadius", _maxRadius);
}

XMLMember AutocorrRing::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="minRadius" ) return XMLMember(0);
  else if(tag=="maxRadius" ) return XMLMember(1);
  else return XMLMember(XMLMember::Unknown);
}

bool AutocorrRing::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  switch (memberID) {
  case 0: _minRadius=content.toDouble(); return true;
  case 1: _maxRadius=content.toDouble(); return true;
  default: return false;
  }
}

void AutocorrRing::round(double step)
{
  TRACE;
  _minRadius=floor(_minRadius/step)*step;
  _maxRadius=ceil(_maxRadius/step)*step;
}

QString AutocorrRing::toUserString() const
{
  return QString("from %1 m to %2 m").arg(_minRadius).arg(_maxRadius);
}

QString AutocorrRing::toString() const
{
  return QString::number(_minRadius)+" "+QString::number(_maxRadius);
}

bool AutocorrRing::fromString(LineParser& p, int startIndex)
{
  bool ok=true;
  _minRadius=p.toDouble(startIndex, ok);
  _maxRadius=p.toDouble(startIndex+1, ok);
  return ok;
}

} // namespace QGpCoreWave
