/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TASKWORKER_H
#define TASKWORKER_H

#include "ParallelLoop.h"

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

  class TaskManager;
  class AbstractTask;

  class QGPCORETOOLS_EXPORT TaskWorker : public LoopWorker
  {
  public:
    TaskWorker();
    ~TaskWorker();

    void setTaskManager(TaskManager * tm) {_taskManager=tm;}
  protected:
    TaskManager * taskManager() {return _taskManager;}

    virtual void run(int);
    virtual void process(AbstractTask * t)=0;
    virtual void mergeResults() {}
  private:
    TaskManager * _taskManager;
  };

} // namespace QGpCoreTools

#endif // TASKWORKER_H

