/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-06-28
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifdef MULTI_PRECISION

#include "RealMP.h"

namespace QGpCoreTools {

  const int RealMP::defaultPrecision=128;
  const RealMP RealMP::null(RealMP::defaultPrecision, 0.0);

  /*!
    \class RealMP RealMP.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    \fn RealMP::RealMP()

    Uninitialized real number. Use setPrecsion() before any operation.
  */

  /*!
    \fn RealMP::RealMP(mpfr_prec_t precision)

    Initialize a \a precision -bit real number
  */

  void RealMP::formatString(char * str, char format, int precision)
  {
    *(str++)='%';
    if(precision>0) {
      *(str++)='.';
      str+=snprintf(str, 24, "%i", precision);
    }
    *(str++)='R';
    *(str++)=format;
    *(str++)=0;
  }

  QString RealMP::toString(char format, int precision) const
  {
    char * fs=new char[32];
    formatString(fs, format, precision);
    QString str=toString(fs);
    delete [] fs;
    return str;
  }

  QString RealMP::toString(char * format) const
  {
    int n=RealMP::precision();
    char * buf=new char[RealMP::precision()]; // Too large but it does not matter
    mpfr_snprintf(buf, n, format, _val);
    QString str(buf);
    delete [] buf;
    return str;
  }

} // namespace QGpCoreTools

#endif // MULTI_PRECISION
