/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef REALSTATISTICALPROXY_H
#define REALSTATISTICALPROXY_H

#include "BasicCurveProxy.h"
#include "StatisticalPoint.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT RealStatisticalProxy : public BasicCurveProxy
  {
    TRANSLATIONS("RealStatisticalProxy")
  public:
    RealStatisticalProxy() : BasicCurveProxy() {_curve=nullptr;}

    virtual QString tag() const {return "RealStatisticalProxy";}

    virtual CurveProxy * clone() const {return new RealStatisticalProxy;}

    CURVEPROXY_BASICDECLARATIONS
    void average(const CurveProxy * o) {
      curve().average(static_cast<const RealStatisticalProxy *>(o)->curve());
    }
    int splitCount(double maxX, SamplingOptions options, double maxErr, int minCount) const;
    void split(const CurveProxy * o, int index, double maxX, SamplingOptions options, double maxErr, int minCount);


    virtual int columnCount() const {return 4;}
    virtual QString columnName(int col) const;
    virtual QString columnUnit(int col) const;

    virtual QVariant columnValue(int sample, int col) const;
    virtual void setColumnValue(int sample, int col, const QVariant & value);

    virtual int xAxisColumn() const {return 0;}
    virtual int xAxisInversedColumn() const  {return -1;}
    virtual int yAxisColumn() const {return 1;}
    virtual int yAxisInversedColumn() const {return -1;}

    virtual QStringList columnFileTypes() const;
    virtual QVector<int> defaultColumnFileTypes() const;
    virtual QVector<int> savedColumns() const;

    virtual bool parse(ColumnTextIterator& it);

    void setCurve(Curve<RealStatisticalPoint> * c) {_curve=c;}
    const Curve<RealStatisticalPoint>& curve() const {return *_curve;}
    Curve<RealStatisticalPoint>& curve() {return *_curve;}
  private:
    Curve<RealStatisticalPoint> *_curve;
  };

} // namespace QGpCoreMath

#endif // REALSTATISTICALPROXY_H

