/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-16
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LINEARREGRESSION_H
#define LINEARREGRESSION_H

#include <QtCore>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT LinearRegression
  {
  public:
    LinearRegression() {reset();}

    void reserve(int count) {_values.reserve(count);}
    void add(double x, double y);
    void reset();

    bool calculate();
    float stddev() const;
    int badValue(double deviation) const;
    void remove(int i);
    void removeFirst();

    unsigned int count() const {return _values.size();}
    double a() const {return _a;}
    double b() const {return _b;}
    double x0() const {return _x0;}
    double at(double x) const {return _a*(x-_x0)+_b;}
  private:
    double _sumX, _sumY, _sumXY, _sumX2, _x0;
    double _a, _b;
    QVector<QPair<double, double> > _values;
  };

} // namespace QGpCoreMath

#endif // LINEARREGRESSION_H
