/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-06-06
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMULTIMODALCURVES_H
#define COMPATMULTIMODALCURVES_H

#include <QGpCoreTools.h>

#include "CompatMultiModalFrequency.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatMultiModalCurves :  public CompatMultiModalFrequency
{
public:
  /// Default constructor
  CompatMultiModalCurves();
  /// Constructor
  CompatMultiModalCurves(int modesCount, int omegasCount);
  /// Copy constructor
  CompatMultiModalCurves(const CompatMultiModalFrequency * o);
  /// Copy constructor changing the number of modes
  CompatMultiModalCurves(const CompatMultiModalFrequency * o,
                      int modesCount);
  /// Copy constructor
  CompatMultiModalCurves(const CompatMultiModalCurves * o);
  /// Copy constructor changing the number of modes
  CompatMultiModalCurves(const CompatMultiModalCurves * o,int modesCount, double invalidValue);
  /// Destructor: get rid of all unused memory
  virtual ~CompatMultiModalCurves();
  
  void clearRefines();
  /// Export curves to stream
  void toStream(FILE * f);
  /// Prints the _values to the binary stream (usually the inversion_report)
  void valuesToReport(QDataStream& s) const;
  /// Loads the _omega from the binary stream (usually the inversion_report) and allocate values
  void reportToOmega(QDataStream& s);
  /// Loads the _slowness from the binary stream (usually the inversion_report)
  void reportToValues(QDataStream& s);
  /// Copy all point of imode into a point vector and return the number of valid points
  int toPointVector(int imode,Point2D * pointList, double invalid_value);
  
  /// Returns the ith slowness of mode m
  double value(int i, int mode) const {return _values[mode][i];}
  /// Set values of mode and point i
  void setValue(int i, int mode,double val) {_values[mode][i]=val;}
  /**Set values of all modes and points from another object
      Better if the set of omegas is the same (not tested)
      If modesCount is different only lower modes are transfered */
  void setValues(CompatMultiModalCurves * o);
  
  void refinesToReport(QDataStream& s) const;
  void reportToRefines(QDataStream& s);
  int refinesCount() const {return _refines.count();}
  void refineSort() {std::sort(_refines.begin(), _refines.end());}
  void clear(double invalid_value);
  void setRayleighModesCount(int rm) {
    if(rm<=_modesCount) _rayleighModesCount=rm;
  }
  uint rayleighModesCount() {return _rayleighModesCount;}
protected:
  friend class CompatMultiModalData;
  /// Storage for calculated values (wave slownesses, ellipticity, ...)
  double ** _values;
  uint _rayleighModesCount;
  /// Delete _values (called by destructor)
  void deleteValues();
  /// Allocates the storage for calculated slownesses
  void allocatesValues();
  /// Refinement list
  QList<Point2D> _refines;
/*protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(CompatStringSection& propertyName,
                               CompatStringSection& content);*/
};

} // namespace QGpCompatibility

#endif // COMPATMULTIMODALCURVES_H
