/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALDISPERSION_H
#define COMPATMODALDISPERSION_H

// To be removed in the future, when Dinver will be completly finished
#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "CompatDispersionData.h"

#include <math.h>

#include "CompatModalEllipticity.h"
#include "CompatModalRefinedCurves.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

#define twopi (2*M_PI)

#define COMPATMODALDISPERSION_INVALID_VALUE 0.0
#define SLOWNESS_MISFIT

class CompatModalEllipticity;

class CompatModalDispersion : public CompatModalRefinedCurves
{
  TRANSLATIONS( "CompatModalDispersion" );
public:
  CompatModalDispersion() {_curves.setInvalidValue(COMPATMODALDISPERSION_INVALID_VALUE);}

  // To be removed in the future, when Dinver will be completly finished
  QGPCOMPATIBILITY_EXPORT CompatDispersionData * oldStyle();
protected:
  virtual const QString& xml_tagName() const {return xmlModalDispersionTag;}
  QGPCOMPATIBILITY_EXPORT static const QString xmlModalDispersionTag;
};

} // namespace QGpCompatibility

#endif // COMPATMODALDISPERSION_H
