/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-17
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATHODOCHRONE_H
#define COMPATHODOCHRONE_H

#include "CompatMultiModalCurves.h"

namespace QGpCompatibility {

#define CompatHODOCHRONE_INVALID_VALUE -1

class CompatSubSignalPool;

class CompatHodoChrone :  public CompatMultiModalCurves
{
public:
  /// Default constructor
  CompatHodoChrone();
  /// Allocates an empty structure
  CompatHodoChrone(int modesCount,int omegasCount);
  /// Copy constructor
  CompatHodoChrone(const CompatMultiModalFrequency *o);
  /// Copy constructor changing the number of modes
  CompatHodoChrone(const CompatMultiModalFrequency *o,int modesCount);
  /// Copy constructor
  CompatHodoChrone(const CompatMultiModalCurves *o);
  /// Copy constructor changing the number of modes
  CompatHodoChrone(const CompatMultiModalCurves * o,int modesCount);
};

inline CompatHodoChrone::CompatHodoChrone(): CompatMultiModalCurves()
{
  TRACE;
  _freq2omega=1.0;
}

inline CompatHodoChrone::CompatHodoChrone(int modesCount,int omegasCount)
  : CompatMultiModalCurves(modesCount, omegasCount)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalFrequency *o)
  : CompatMultiModalCurves(o)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalFrequency *o,int modesCount)
  : CompatMultiModalCurves(o, modesCount)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalCurves *o)
  : CompatMultiModalCurves(o)
{
  TRACE;
  _freq2omega=1.0;  
}

inline CompatHodoChrone::CompatHodoChrone(const CompatMultiModalCurves * o,int modesCount)
  : CompatMultiModalCurves(o, modesCount, CompatHODOCHRONE_INVALID_VALUE)
{
  TRACE;
  _freq2omega=1.0;  
}

} // namespace QGpCompatibility

#endif // COMPATHODOCHRONE_H
