/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-20
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPECTRUMTOOL_H
#define SPECTRUMTOOL_H

#include "AbstractHVTool.h"
#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT SpectrumTool : public AbstractHVTool
  {
  public:
    SpectrumTool(QObject * parent=nullptr);

    bool setSubPool(SubSignalPool * subPool);
  protected:
    virtual AbstractStation * createStation(StationSignals * sigs);
    virtual QString toolName() {return tr("Spectrum");}
  };

} // namespace HVCore

#endif // SPECTRUMTOOL_H

