/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-11-15
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef NEWNOISEMODEL_H
#define NEWNOISEMODEL_H

#include <QGpCoreMath.h>

#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT NewNoiseModel
  {
  public:
    enum Type {LowAcceleration, HighAcceleration, LowVelocity, HighVelocity, LowDisplacement, HighDisplacement};

    Curve<Point2D> curve(Type t, const SamplingParameters &sampling);

    static double lowAcceleration(double frequency, bool& ok);
    static double highAcceleration(double frequency, bool& ok);
    static double lowVelocity(double frequency, bool& ok);
    static double highVelocity(double frequency, bool& ok);
    static double lowDisplacement(double frequency, bool& ok);
    static double highDisplacement(double frequency, bool& ok);
  private:
    static double interpole(double period, int n, const double * periods, const double * a, const double * b, bool& ok);

    static const double lowPeriods[];
    static const double lowA[];
    static const double lowB[];
    static const double highPeriods[];
    static const double highA[];
    static const double highB[];
  };
}

#endif // NEWNOISEMODEL_H
