/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-20
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HVStation.h"
#include "CurveResults.h"
#include "HVStationSignals.h"

namespace HVCore {

  /*!
    \class HVStation HVStation.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  HVStation::HVStation(StationSignals * sig)
    : AbstractStation(new StationProcessSignals(sig))
  {
    TRACE;
  }

  bool HVStation::save(int, QDir outputDir, const HVParameters& param)
  {
    TRACE;
    QString fileName=_signals->originalSignals()->name();;
    fileName=outputDir.absoluteFilePath(fileName+".hv");
    return _results[0]->save(fileName, log(param));
  }

  StationProcessSignals * HVStation::createProcessSignals()
  {
    return new HVStationSignals;
  }

  AbstractResults * HVStation::createResults()
  {
    AbstractResults * r=new CurveResults(this);
    r->setName(originalSignals()->name());
    connect(r, SIGNAL(colorsToChange(const QVector<int>*, const Color&)),
            this, SLOT(changeColors(const QVector<int>*, const Color&)));
    return r;
  }

  void HVStation::process(StationProcessSignals * proc, int windowIndex, const HVParameters * param) const
  {
    TRACE;
    HVStationSignals * hvProc=static_cast<HVStationSignals *>(proc);
    const TimeWindow& r=windowAt(windowIndex);
    hvProc->setProcessed(_signals, r, param);

    Curve<Point2D> hv;
    switch (param->horizontal()) {
    case HVParameters::Energy:
      hv=hvProc->horizontal(param);
      break;
    case HVParameters::Azimuth:
      hv=hvProc->horizontal(param->horizontalAzimuth(), param);
      break;
    case HVParameters::Squared:
      hv=hvProc->horizontal(param, 0.5);
      break;
    }
    hv.yDivide(hvProc->vertical());
    _results[0]->setWindow(windowIndex, r.lengthSeconds(), hv);
    _results[0]->setWindowColor(windowIndex, r.color());
  }

} // namespace HVCore

