/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-03
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HVPARAMETERS_H
#define HVPARAMETERS_H

#include <GeopsyCore.h>

#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT HVParameters : public AbstractParameters
  {
  public:
    HVParameters();
    HVParameters(const HVParameters& o);

    virtual AbstractParameters * clone() const {return new HVParameters(*this);}

    enum HorizontalType {Energy, Azimuth, Squared};

    TimeRangeParameters& timeRange() {return _timeRange;}
    const TimeRangeParameters& timeRange() const {return _timeRange;}
    void setTimeRange(const TimeRangeParameters& r) {_timeRange=r;}

    bool commonTimeWindows() const {return _commonTimeWindows;}
    void setCommonTimeWindows(bool c) {_commonTimeWindows=c;}

    WindowingParameters& windowing() {return _windowing;}
    const WindowingParameters& windowing() const {return _windowing;}
    void setWindowing(const WindowingParameters& w) {_windowing=w;}

    SamplingParameters& sampling() {return _sampling;}
    const SamplingParameters& sampling() const {return _sampling;}
    void setSampling(const SamplingParameters& s) {_sampling=s;}

    WindowFunctionParameters& tapering() {return _tapering;}
    const WindowFunctionParameters& tapering() const {return _tapering;}
    void setTapering(const WindowFunctionParameters& t) {_tapering=t;}

    SmoothingParameters& smoothing() {return _smoothing;}
    const SmoothingParameters& smoothing() const {return _smoothing;}
    void setSmoothing(const SmoothingParameters& s) {_smoothing=s;}

    const double& highPassFrequency() const {return _highPassFrequency;}
    void setHighPassFrequency(const double& h) {_highPassFrequency=h;}

    HorizontalType horizontal() const {return _horizontal;}
    QString horizontalString() const;
    void setHorizontal(HorizontalType h) {_horizontal=h;}
    void setHorizontal(const QString& h);

    const double& horizontalAzimuth() const {return _horizontalAzimuth;}
    void setHorizontalAzimuth(const double& h) {_horizontalAzimuth=h;}

    bool doMakeUp() const {return _doMakeUp;}
    void setDoMakeUp(bool d) {_doMakeUp=d;}

    const QString& makeUpResults() const {return _makeUpResults;}
    void setMakeUpResults(const QString& m) {_makeUpResults=m;}

    const QString& makeUpSummary() const {return _makeUpSummary;}
    void setMakeUpSummary(const QString& m) {_makeUpSummary=m;}

    const int& plotCountPerLineResults() const {return _plotCountPerLineResults;}
    void setPlotCountPerLineResults(const int& p) {_plotCountPerLineResults=p;}

    const double& pageHeightResults() const {return _pageHeightResults;}
    void setPageHeightResults(const double& p) {_pageHeightResults=p;}

    double rotationStep() const {return _rotationStep;}
    void setRotationStep(double s) {_rotationStep=s;}

    virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
    virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
    virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    virtual int totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const;
  private:
    TimeRangeParameters _timeRange;
    bool _commonTimeWindows;
    WindowingParameters _windowing;
    SamplingParameters _sampling;
    SmoothingParameters _smoothing;
    WindowFunctionParameters _tapering;
    double _horizontalAzimuth;
    double _highPassFrequency;

    HorizontalType _horizontal;
    int _plotCountPerLineResults;
    bool _doMakeUp;
    QString _makeUpResults;
    QString _makeUpSummary;
    double _pageHeightResults;
    double _rotationStep;
  };

} // namespace HVCore

#endif // HVPARAMETERS_H
