/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  GeopsySLinkGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLinkGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-03
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKLOADEROPTIONS_H
#define SEEDLINKLOADEROPTIONS_H

#include <QGpGuiTools.h>
#include <GeopsySLink.h>

#include "ui_SeedLinkLoaderOptions.h"
#include "GeopsySLinkGuiDLLExport.h"

namespace GeopsySLinkGui {

class GEOPSYSLINKGUI_EXPORT SeedLinkLoaderOptions : public Dialog, private Ui::SeedLinkLoaderOptions
{
  Q_OBJECT
public:
  SeedLinkLoaderOptions(QWidget * parent=nullptr);

  void updateAllFields();
  static void restore(SeedLink * sl);
  void getParam(SeedLink * sl);
public slots:
  void bufferToggled();
  void fromTimeToggled();
  void on_maxDurationUnit_activated(int index);
private:
  static double unitFactor(int index);
};

} // namespace GeopsySLinkGui

#endif // SEEDLINKLOADEROPTIONS_H
