/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  GeopsySLink is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLink is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SeedLinkServer.h"
#include "SeedLinkStation.h"
#include "SeedLinkStream.h"

namespace GeopsySLink {

/*!
  \class SeedLinkServer SeedLinkServer.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString SeedLinkServer::xmlSeedLinkServerTag="seedlink";

/*!
  Description of destructor still missing
*/
SeedLinkServer::~SeedLinkServer()
{
  TRACE;
  clear();
}

void SeedLinkServer::clear()
{
  TRACE;
  qDeleteAll(*static_cast<QList<SeedLinkStation *> *>(this));
  QList<SeedLinkStation *>::clear();
}

void SeedLinkServer::xml_attributes(XML_ATTRIBUTES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  static const QString keys[]={ "software", "organization", "started" };
  attributes.add(keys[0], _software);
  attributes.add(keys[1], _organization);
  attributes.add(keys[2], _beginTime);
}

bool SeedLinkServer::xml_setAttributes(XML_SETATTRIBUTES_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  for(XMLRestoreAttributeIterator it=attributes.begin(); it!= attributes.end(); it++ ) {
    const StringSection& att=it.key();
    if(att.size()<2) return false;
    switch (att[1].unicode()) {
    case 't':
      if(att=="started" ) _beginTime=it.value().toString(); else return false;
      break;
    case 'r':
      if(att=="organization" ) _organization=it.value().toString(); else return false;
      break;
    case 'o':
      if(att=="software" ) _software=it.value().toString(); else return false;
      break;
    default:
      return false;
    }
  }
  return true;
}

void SeedLinkServer::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  for(const_iterator it=begin(); it!=end(); it++ ) {
    XMLSaveAttributes attributes;
    (*it)->xml_attributes(attributes, context);
    (*it)->xml_save(s, context, attributes);
  }
}

XMLMember SeedLinkServer::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="station" ) {
    SeedLinkStation * station=new SeedLinkStation(this);
    append(station);
    return XMLMember(station);
  } else return XMLMember(XMLMember::Unknown);
}

bool SeedLinkServer::xml_polish(XML_POLISH_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  std::sort(begin(), end(), SeedLinkStation::lessThan);
  return true;
}

QList<int> SeedLinkServer::indexOf(QRegExp networkStation) const
{
  TRACE;
  QList<int> indexes;
  for(int i=count()-1; i>=0;i-- ) {
    const SeedLinkStation * s=at(i);
    if(networkStation.indexIn(s->network()+"_"+s->name())!=-1) {
      indexes.append(i);
    }
  }
  return indexes;
}

SubSignalPool SeedLinkServer::allSignals() const
{
  TRACE;
  SubSignalPool subPool;
  for(const_iterator it=begin(); it!=end(); it++) {
    const SeedLinkStation * stat=*it;
    int n=stat->count();
    for(int i=0; i<n; i++) {
      const SeedLinkStream * stream=stat->at(i);
      Signal * sig=stream->signal();
      if(sig) {
        subPool.addSignal(sig);
      }
    }
  }
  return subPool;
}


} // namespace GeopsySLink
