/***************************************************************************
**
**  This file is part of GeopsyLand.
**
**  GeopsyLand is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyLand is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-03
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TERMINAL_H
#define TERMINAL_H

#include <QGpGuiTools.h>

class MiniBash;

class Terminal : public QPlainTextEdit
{
  Q_OBJECT
public:
  Terminal(QWidget *parent=nullptr);
  ~Terminal();

  void addPath(const QString& p);

  void putData(const QString& data);
  void putData(const QStringList& data);

  void exit();
protected:
  void keyPressEvent(QKeyEvent *e);
  void mousePressEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void mouseDoubleClickEvent(QMouseEvent *e);
  void contextMenuEvent(QContextMenuEvent *e);
private slots:
  void processFinished();
private:
  void addPrompt();
  void addLineContinued();
  void completion();
  void clearLine();

  int _promptLength;
  QString _completionWord;
  QTextCursor _selection;
  MiniBash * _interpreter;
};

#endif // TERMINAL_H

