/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PicksProperties.h"
#include "PickItem.h"

namespace GeopsyGui {

/*!
  Constructs a PicksProperties as a child of 'parent'.
*/
PicksProperties::PicksProperties(QWidget* parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  PickItem * m=new PickItem(this);
  picks->setModel(m);
  picks->setSelectionBehavior(QAbstractItemView::SelectItems);
  picks->setSelectionMode(QAbstractItemView::ExtendedSelection);
  picks->setEditTriggers(QAbstractItemView::AllEditTriggers);
}

PropertyValue::WidgetType PicksProperties::determineCustomWidgetType(int, QWidget *, QWidget * )
{
  return PropertyValue::Custom0;
}

void PicksProperties::setWidgets()
{
  PickItem * model=static_cast<PickItem *>(picks->model());
  model->beginPickChange();
  PropertyWidget::setWidgets();
  model->endPickChange();
}

void PicksProperties::on_picks_clicked(const QModelIndex& index)
{
  TRACE;
  if(index.column()==2) {
    QColor c=picks->model()->data(index, Qt::BackgroundRole).value<QColor>();
    c=QColorDialog::getColor(c, this);
    if(c.isValid()) {
      picks->model()->setData(index, c, Qt::BackgroundRole);
    }
  }
}

void PicksProperties::on_defaultColors_clicked()
{
  TRACE;
  int n=picks->model()->rowCount();
  for(int i=0; i<n; i++) {
    QColor c=QColor::fromHsv(( int) (( double) i * 330.0/(double) n), 255, 255, 255);
    picks->model()->setData(picks->model()->index(i, 1), c, Qt::BackgroundRole);
  }
  picks->reset();
}

} // namespace GeopsyGui
