/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-09
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NORMALIZATIONPARAMETERWIDGET_H
#define NORMALIZATIONPARAMETERWIDGET_H

#include <GeopsyCore.h>
#include "ui_NormalizationParameterWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT NormalizationParameterWidget : public QWidget, public Ui::NormalizationParameterWidget
  {
    Q_OBJECT
  public:
    NormalizationParameterWidget(QWidget * parent=nullptr);

    void setExternalRange();

    void getParameters(NormalizationParameters & param) const;
    void setParameters(const NormalizationParameters & param);
  public slots:
    void typeChanged();
  signals:
    void parametersChanged();
  private:
    NormalizationParameters::Type type() const;
  };

} // namespace GeopsyGui

#endif // NORMALIZATIONPARAMETERWIDGET_H
