/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYGUIENGINE_H
#define GEOPSYGUIENGINE_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

class SignalTableItem;

namespace GeopsyGui {

  class SubPoolWindow;
  class AbstractGraphicWindow;

  class GEOPSYGUI_EXPORT GeopsyGuiEngine : public GeopsyCoreEngine
  {
  public:
    static GeopsyGuiEngine * instance() {return static_cast<GeopsyGuiEngine *>(GeopsyCoreEngine::instance());}

    virtual SignalDatabase * database(QWidget *) {return nullptr;}

    virtual MultiDocumentSubWindow * addSubWindow(QWidget * /*parent*/, QWidget * /*w*/) {return nullptr;}
    virtual void removeSubWindow(QWidget * /*w*/) {}

    virtual AbstractGraphicWindow * newGraphicWindow(QWidget * /*parent*/, const SubSignalPool& subPool=SubSignalPool()) {Q_UNUSED(subPool) return nullptr;}
    virtual SubPoolWindow * newTableWindow(QWidget * /*parent*/, const SubSignalPool& subPool=SubSignalPool()) {Q_UNUSED(subPool) return nullptr;}
    virtual SubPoolWindow * newMapWindow(QWidget * /*parent*/, const SubSignalPool& subPool=SubSignalPool()) {Q_UNUSED(subPool) return nullptr;}
    virtual SubPoolWindow * newChronogramWindow(QWidget * /*parent*/, const SubSignalPool& subPool=SubSignalPool()) {Q_UNUSED(subPool) return nullptr;}

    virtual QWidgetList subWindowList(QWidget * /*parent*/) const {return QWidgetList();}

    virtual QStatusBar * statusBar() {return nullptr;}
    virtual ProgressBar * progressBar() {return nullptr;}

    virtual SignalFileFormat askLoadFormat(const QString& signalFileName);
    virtual bool askRD3LogParameter(int& nSamples, double& sampFreq, double& t0);
  };

} // namespace GeopsyGui

#endif // GEOPSYGUIENGINE_H
