/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TimeWindow.h"

namespace GeopsyCore {

  /*!
    \class TimeWindow TimeWindow.h
    \brief A colored time range

  */

  const QString TimeWindow::xmlTimeWindowTag="TimeWindow";

  void TimeWindow::xml_attributes(XML_ATTRIBUTES_ARGS) const
  {
    Q_UNUSED(context)
    static const QString keys[]={"start", "end", "color"};
    attributes.add(keys[0], start().toString());
    attributes.add(keys[1], end().toString());
    attributes.add(keys[2], _color.name());
  }

  bool TimeWindow::xml_setAttributes(XML_SETATTRIBUTES_ARGS)
  {
    Q_UNUSED(context)
    XMLRestoreAttributeIterator it;
    bool ok=true;
    for(it=attributes.begin(); it!=attributes.end();it++) {
      const StringSection& att=it.key();
      switch(att[0].unicode()) {
      case 's':
        setStart(it.value().toTime(DateTime::defaultFormat, &ok));
        if(!ok) return false;
        break;
      case 'e':
        setEnd(it.value().toTime(DateTime::defaultFormat, &ok));
        if(!ok) return false;
        break;
      case 'c':
        _color.setNamedColor(it.value().toString());
        break;
      default:
        App::log(tr("Bad attribute: %1\n").arg(att.toString()) );
        return false;
      }
    }
    return true;
  }

} // namespace GeopsyCore
