/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-02
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPARSEKEEPSIGNAL_H
#define SPARSEKEEPSIGNAL_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"
#include "SparseTimeRange.h"

namespace GeopsyCore {

class KeepSignal;

class GEOPSYCORE_EXPORT SparseKeepSignal : private SparseTimeRange
{
  TRANSLATIONS("SparseKeepSignal")
public:
  SparseKeepSignal();
  SparseKeepSignal(const SparseTimeRange& r);
  SparseKeepSignal(const SparseKeepSignal& o);
  ~SparseKeepSignal();

  bool setSampling(const TimeRange& sigRange, double deltaT);
  void initValues(int value, const DateTime& start=DateTime::minimumTime,
                  const DateTime& end=DateTime::maximumTime);
  void copySamplesFrom(const SparseKeepSignal& o);

  SparseKeepSignal * intersection(const TimeRange& r) const;
  void remove(const TimeRange& r);

  SparseTimeRange timeRange() const {return *this;}
  ::QVector<KeepSignal *> keeps(const TimeRange& r) const;
  const ::QVector<KeepSignal *>& keeps() const {return _keeps;}

  void printDebug() const {SparseTimeRange::printDebug();}
private:
  static KeepSignal * cutStart(const KeepSignal * keep, const DateTime& t);
  static KeepSignal * cutEnd(const KeepSignal * keep, const DateTime& t);

  ::QVector<KeepSignal *> _keeps;
};

} // namespace GeopsyCore

#endif // SPARSEKEEPSIGNAL_H
