/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-11-10
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALFILEPOOL_H
#define SIGNALFILEPOOL_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"
#include "SignalFile.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

class SignalDatabase;

class GEOPSYCORE_EXPORT SignalFilePool : private QList<SignalFile *>
{
  TRANSLATIONS("SignalFilePool")
public:
  SignalFilePool(SignalDatabase * db) {_db=db;}
  ~SignalFilePool();

  typedef QList<SignalFile *>::iterator iterator;
  typedef QList<SignalFile *>::const_iterator const_iterator;
  SignalFile * last() const {return QList<SignalFile *>::last();}
  SignalFile * at(int index) const {return QList<SignalFile *>::at(index);}
  int indexOf(SignalFile * f) const {return QList<SignalFile *>::indexOf(f);}
  int count() const {return QList<SignalFile *>::count();}
  const_iterator begin() const {return QList<SignalFile *>::begin();}
  const_iterator end() const {return QList<SignalFile *>::end();}
  iterator begin() {return QList<SignalFile *>::begin();}
  iterator end() {return QList<SignalFile *>::end();}
  void add(SignalFilePool& files);

  SignalFile * find(QString fileName) const;
  bool load(QString name, SignalFileFormat format=SignalFileFormat::Unknown);
private:
  friend class SignalDatabase;
  void clear();
  void remove (SignalFile * f);
  void insert(int before, SignalFile * f) {QList<SignalFile *>::insert(before, f);}
  void move(int from, int to) {QList<SignalFile *>::move(from, to);}
  void append(SignalFile * f) {QList<SignalFile *>::append(f);}
  SignalDatabase * _db;
};

} // namespace GeopsyCore

#endif // SIGNALFILEPOOL_H
