/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-01-30
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ORIGINALFILENAME_H
#define ORIGINALFILENAME_H

#include "MetaData.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT OriginalFileName : public MetaString
  {
    METADATA_CLASS(OriginalFileName)
  public:
    OriginalFileName() {}
    OriginalFileName(const QString& str) : MetaString(str) {}
    OriginalFileName(const OriginalFileName& o) : MetaString(o) {}

    virtual QStringList subNames() const;
    virtual QString name(int, const QString&) const;
    virtual QString baseName(int) const;
    virtual QString title(int, const QString&) const;
  };

} // namespace GeopsyCore

#endif // ORIGINALFILENAME_H
