/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDVOLUME_H
#define MINISEEDVOLUME_H

#include <QGpCoreTools.h>
#include <mseed.h>

namespace GeopsyCore {

class MiniSeedTrace;

class MiniSeedVolume : public QVector<MiniSeedTrace *>
{
  TRANSLATIONS("MiniSeedVolume")
public:
  ~MiniSeedVolume();

  bool read(QString name);
  static bool isValid(QString fileName);
  static void errorMessage(QString fileName, QString title, int errorCode);
  static void errorLog(QString fileName, QString title, int errorCode);
  static void nonAsciiPathError(QString fileName);
private:
  static QString errorString(int errorCode);
  MiniSeedTrace * findTrace(LibMSeed::MSRecord * msr);
};

} // namespace GeopsyCore

#endif // MINISEEDVOLUME_H
