/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-29
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MetaDataFieldList.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class MetaDataFieldList MetaDataFieldList.h
    \brief A list of MetaDataField

    Full description of class still missing
  */

  void MetaDataFieldList::setDefaults()
  {
    TRACE;
    clear();
    add(MetaDataField(MetaDataFactory::ID));
    add(MetaDataField(MetaDataFactory::Name));
    add(MetaDataField(MetaDataFactory::Component));
    add(MetaDataField(MetaDataFactory::StartTime));
    add(MetaDataField(MetaDataFactory::EndTime));
    add(MetaDataField(MetaDataFactory::SamplingFrequency));
    add(MetaDataField(MetaDataFactory::SamplingPeriod));
    add(MetaDataField(MetaDataFactory::NSamples));
    add(MetaDataField(MetaDataFactory::Duration));
    add(MetaDataField(MetaDataFactory::ReceiverX));
    add(MetaDataField(MetaDataFactory::ReceiverY));
  }

  void MetaDataFieldList::setAll()
  {
    TRACE;
    QList<MetaDataIndex> list=MetaDataFactory::instance()->registeredData();
    std::sort(list.begin(), list.end());
    int n=list.count();
    clear();
    for(int i=0;i<n;i++) {
      add(list.at(i));
    }
  }

  void MetaDataFieldList::getSettings()
  {
    TRACE;
    QSettings& reg=CoreApplication::instance()->settings();
    reg.beginGroup("TableFields");
    if(!reg.contains("names") || !reg.contains("titles")) {
      setDefaults();
      return;
    }
    QStringList names, titles;
    names=reg.value("names").toStringList();
    titles=reg.value("titles").toStringList();
    if(names.count()!=titles.count()) {
      setDefaults();
      return;
    }
    QStringList::Iterator itNames=names.begin();
    QStringList::Iterator itTitles=titles.begin();
    clear();
    for(int i=0;itNames!=names.end();++itNames, ++itTitles, i++) {
      MetaDataIndex index=MetaDataFactory::instance()->index(*itNames);
      if(!index.isValid()) {
        index=MetaDataIndex(MetaDataFactory::Dummy);
      }
      append(MetaDataField(index, *itTitles));
    }
  }

  void MetaDataFieldList::setSettings() const
  {
    TRACE;
    QStringList names, titles;
    for(const_iterator it=begin();it!=end();++it) {
      const MetaDataField& f=*it;
      names.append(MetaDataFactory::instance()->name(f));
      titles.append(f.title());
    }
    QSettings& reg=CoreApplication::instance()->settings();
    reg.beginGroup("TableFields");
    reg.setValue("names",names);
    reg.setValue("titles",titles);
  }

} // namespace GeopsyCore
