/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-10-21
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALFORMATCOMPONENT_H
#define ASCIISIGNALFORMATCOMPONENT_H

#include <QtCore>

#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT AsciiSignalFormatComponent : public XMLClass
{
public:
  AsciiSignalFormatComponent();
  AsciiSignalFormatComponent(const AsciiSignalFormatComponent& o);

  virtual const QString& xml_tagName() const {return xmlComponentTag;}
  static const QString xmlComponentTag;

  const QString& pattern() const {return _pattern;}
  void setPattern(const QString& p) {_pattern=p;}

  Signal::Components component() const {return _component;}
  void setComponent(Signal::Components c) {_component=c;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _pattern;
  Signal::Components _component;
};

} // namespace GeopsyCore

#endif // ASCIISIGNALFORMATCOMPONENT_H
