/***************************************************************************
**
**  This file is part of DinverGui.
**
**  DinverGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>
#include "ParamSpaceEditor.h"

namespace DinverGui {

/*!
  \class ParamSpaceEditor ParamSpaceEditor.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ParamSpaceEditor::ParamSpaceEditor(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);
  connect(checkBut, SIGNAL(clicked()), this, SIGNAL(check()));

  codeEdit->setText( "// This is just an example\n"
                     "// It defines parameters, their range, their scale type (log or linear)\n"
                     "// and their maximum precision (relative for log scale and absolute for\n"
                     "// linear scale).\n"
                     "parameter(\"v0\",\"m/s\",100,1000, \"log\", 0.05);\n"
                     "parameter(\"v1\",\"m/s\",500,1500, \"linear\", 50);\n"
                     "// Define conditions\n"
                     "//  A simple one: v0<1*v1+0\n"
                     "linear(\"v0\",\"<\",1,\"v1\",0);\n"
                     "// If there is a need for more complex conditions, send your request to marc@geopsy.org" );

  RealSpace sp;
  ParamExpressionContext context(&sp);
  codeEdit->setContext(context);
}

ParamSpaceScript * ParamSpaceEditor::script()
{
  TRACE;
  ParamSpaceScript * s=new ParamSpaceScript;
  s->setText(codeEdit->text());
  return s;
}

QString ParamSpaceEditor::text()
{
  TRACE;
  return codeEdit->text();
}

void ParamSpaceEditor::setFrom(const ParamSpaceScript * script)
{
  TRACE;
  codeEdit->setText(script->text());
}

void ParamSpaceEditor::setFrom(QString script)
{
  TRACE;
  codeEdit->setText(script);
}

void ParamSpaceEditor::setEditable(bool e)
{
  TRACE;
  codeEdit->setReadOnly( !e);
}

} // namespace DinverGui
