/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "XMLVirtualPlugin.h"

namespace DinverCore {

  /*!
    \class XMLVirtualPlugin XMLVirtualPlugin.h
    \brief Brief description of class still missing

    Lets export/import XML content for any plugin just specified by its pluginTag.
    XMLDinver operates on the plugin's internal data members while this class
    operates on any object provided to the constructor. This class is mainly used
    to access dinver XML files from secondary tools (command line utilities that does
    not link to a plugin library) or from target specification widgets.

    It inherits XMLDinver for compatibility with XMLDinverHeader.
  */

  XMLVirtualPlugin::XMLVirtualPlugin(XMLClass * object, QString pluginTag)
    : XMLDinver(0)
  {
    _pluginTag=pluginTag;
    _object=object;
  }

  void XMLVirtualPlugin::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
  {
    TRACE;
    Q_UNUSED(context)
    writeProperty(s, "pluginTag", _pluginTag);
  }

  void XMLVirtualPlugin::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
  {
    TRACE;
    _object->xml_save(s, context);
  }

  XMLMember XMLVirtualPlugin::xml_member(XML_MEMBER_ARGS)
  {
    Q_UNUSED(attributes)
    Q_UNUSED(context)
    if(tag=="pluginTag") return XMLMember(0);
    else if(tag==_object->xml_tagName()) return XMLMember(_object);
    else if(tag=="pluginTitle") return XMLMember(1);
    else if(tag=="newRunDirectory") return XMLMember(2); // Kept for compatibility
    else return XMLMember(XMLMember::Unknown);
  }

  bool XMLVirtualPlugin::xml_setProperty(XML_SETPROPERTY_ARGS)
  {
    TRACE;
    Q_UNUSED(tag)
    Q_UNUSED(attributes)
    Q_UNUSED(context)
    switch (memberID) {
    case 0:
      return content==_pluginTag;
    case 1: // silently ignored
      return true;
    case 2: // Kept for compatibility
      return true;
    default:
      return false;
    }
  }

  void XMLVirtualPlugin::xml_polishChild(XML_POLISHCHILD_ARGS)
  {
    TRACE;
    _object->xml_polishChild(child, context);
  }

} // namespace DinverCore
