/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLDINVERHEADER_H
#define XMLDINVERHEADER_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"
#include "XMLDinver.h"

namespace DinverCore {

class DinverInterface;

class DINVERCORE_EXPORT XMLDinverHeader : public XMLHeader
{
  TRANSLATIONS("XMLDinverHeader")
public:
  XMLDinverHeader(XMLDinver * object) : XMLHeader(object) {}
  XMLDinverHeader(const XMLDinverHeader& o) : XMLHeader(o) {}
protected:
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual void xml_polishChild(XML_POLISHCHILD_ARGS);
};

} // namespace DinverCore

#endif // XMLDINVERHEADER_H
