/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "XMLDinverHeader.h"
#include "XMLDinver.h"
#include "DinverCoreEngine.h"
#include "DinverInterface.h"

namespace DinverCore {

/*!
  \class XMLDinverHeader XMLDinverHeader.h
  \brief Brief description of class still missing

  No dependency to DinverCoreEngine nor to current plugin.
*/

XMLMember XMLDinverHeader::xml_member(XML_MEMBER_ARGS)
{
  if(tag=="Dinver") {
    _tag="Dinver";
    return XMLMember(_object);
  } else if(tag==XMLHeader::xmlHeaderTag) {
    _tag=xmlHeaderTag;
    return XMLMember(this);
  } else if(tag==XMLHeader::xmlHeaderOldTag) {
    _tag=xmlHeaderTag;
    return XMLMember(this);
  } else {
    return _object->xml_member(tag, attributes, context);
  }
}

void XMLDinverHeader::xml_polishChild(XML_POLISHCHILD_ARGS)
{
  TRACE;
  if(child->xml_tagName()!="Dinver") {
    _object->xml_polishChild(child, context);
  }
  _polished=true;
}

} // namespace DinverCore
