/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-17
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ParameterGrid.h"

namespace DinverCore {

  /*!
    \class ParameterGrid ParameterGrid.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ParameterGrid::ParameterGrid()
  {
    _realValues=nullptr;
    _minimum=0.0;
    _maximum=1.0;
    _a=100.0;
    _b=0.01;
    _c=0.0;
    _n=100;
    _scale=Linear;
    _precision=0.0;
  }

  /*!
    Description of destructor still missing
  */
  ParameterGrid::~ParameterGrid()
  {
    delete [] _realValues;
  }

  bool ParameterGrid::init()
  {
    TRACE;
    delete [] _realValues;
    if(_minimum>_maximum) {
      _n=0;
      _realValues=nullptr;
      App::log(tr("Minimum (%1) is greater than maximum (%2).\n").arg(_minimum).arg(_maximum) );
      return false;
    } else if(_minimum==_maximum) {
      _n=0;
      _realValues=nullptr;
      return true;
    }
    if(_minimum<=0.0 && _scale==Log) {
      _scale=Linear;
    }
    bool defaultBinCount;
    if(_precision>0.0) {
      switch(_scale) {
      case Linear:
        _a=1.0/_precision;
        _b=_precision;
        _n=qFloor((_maximum-_minimum)*_a);
        break;
      case Log:
        _a=1.0/_minimum;
        _c=1.0+_precision;
        _b=1.0/log(_c);
        _n=qFloor(log(_maximum*_a)*_b);
        break;
      }
      if(_n>1000000) {
        App::log(tr("Number of bins exceed 1e6 (%1), back to default number of bins.\n").arg(static_cast<double>(_n), 0, 'g') );
        defaultBinCount=true;
      } else if(_n<100) {
        defaultBinCount=true;
      } else {
        defaultBinCount=false;
      }
    } else {
      defaultBinCount=true;
    }
    if(defaultBinCount) { // By default 100 bins
      switch(_scale) {
      case Linear:
        _a=100.0/(_maximum-_minimum);
        _b=1.0/_a;
        break;
      case Log:
        _a=1.0/_minimum;
        _b=100.0/log(_maximum/_minimum);
        _c=exp(1.0/_b);
        break;
      }
      _n=100;
    }
    _realValues=new double[_n+1];
    switch(_scale) {
    case Linear:
      for(int i=0; i<=_n; i++) {
        _realValues[i]=_minimum+static_cast<double>(i)*_b;
      }
      break;
    case Log:
      _realValues[0]=_minimum;
      for(int i=1; i<=_n; i++) {
        _realValues[i]=_realValues[i-1]*_c;
      }
      break;
    }
    return _realValues;
  }

} // namespace DinverCore
