/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-06
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BESTMODELS_H
#define BESTMODELS_H

#include "DinverCoreDLLExport.h"
#include "ActiveModels.h"

namespace DinverCore {

class DINVERCORE_EXPORT BestModels : private IncreaseStorage
{
public:
  BestModels(ActiveModels * models);
  BestModels(const BestModels& o);
  ~BestModels();

  void print();

  void setModels(ActiveModels * models) {_models=models;}
  void setNr(int nr);
  void update();
  void add(int modelIndex);
  void setIndex(int bestIndex, int modelIndex) {_indexes[bestIndex]=modelIndex;}
  void remove(int modelIndex);
  void clear();

  void reserve(int n) {IncreaseStorage::reserve(n);}
  int count() const {return size();}
  int modelIndex(int bestIndex) const {return _indexes[ bestIndex ];}
  const double * misfit(int bestIndex) const {return _models->misfit(_indexes[bestIndex]);}
  const int * model(int bestIndex) const {return _models->model(_indexes[bestIndex]);}

  int * activeModelMap() const;
  int * allModelMap() const;
private:
  virtual void reallocate();
  int indexOf(double m) const;
  int exactIndexOf(int modelIndex, double m, int approxIndex) const;
  inline void add();

  ActiveModels * _models;
  int * _indexes;
  int _nrMax, _nr2;
};

inline void BestModels::add()
{
  IncreaseStorage::add();
  while(_nr2<size()) _nr2=_nr2 << 1;
}

} // namespace DinverCore

#endif // BESTMODELS_H
