/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACLOOP_H
#define SPACLOOP_H

#include <QGpCoreTools.h>
#if 0
#include "ArrayLoop.h"
#include "ArrayStations.h"
#include "SPACParameters.h"
#include "SPACCrossSpectrum.h"
#include "SPACResults.h"
#include "SPACStatistics.h"

namespace ArrayCore {

  class SPACLoop : public ArrayLoop
  {
  public:
    SPACLoop(const ArraySelection * array);
    ~SPACLoop();

    bool setParameters(const ArrayParameters * p);
    const SPACParameters * parameters() const {return static_cast<const SPACParameters *>(ArrayLoop::parameters());}

    SPACResults * results() const {return static_cast<SPACResults *>(ArrayLoop::results());}
  protected:
    virtual LoopWorker * newWorker();
  private:
    void setTarget();
    void setStmap();
    void setMax();
  };

  class SPACLoopWorker : public LoopWorker
  {
  public:
    SPACLoopWorker();
    ~SPACLoopWorker();

    virtual void setArray(const ArraySelection * array);
    void setParameters(const SPACParameters * param);
    void setLoop(const SPACLoop * l) {_loop=l;}
  protected:
    virtual void run(int index);
  private:
    inline void writeMax(int iComp, int iRing, double value);

    const SPACLoop * _loop;
    SPACCrossSpectrum * _crossSpectrum;
    SPACStatistics _stats;
  };

} // namespace ArrayCore
#endif
#endif // SPACLOOP_H
