/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-12
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HRFKDirectRayleighVertical.h"
#include "FKCrossSpectrum.h"
#include "FKGridSearch.h"
#include "HRFKRayleighEllipticity.h"
#include "FKPower.h"
#include "FKSteeringThreeComponentRayleighVertical.h"

namespace ArrayCore {

  /*!
    \class HRFKDirectRayleighVertical HRFKDirectRayleighVertical.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void HRFKDirectRayleighVertical::initGrid(const Point& kell, int index)
  {
    FKSteeringThreeComponentRayleighVertical::init(_gridCache, index , kell);
  }

  double HRFKDirectRayleighVertical::value(const Point& kell, int index) const
  {
    if(isInsideLimits(kell)) {
      FKPower p(&FKSteeringThreeComponentRayleighVertical::cache(_gridCache, index));
      p.setCaponValue(_crossSpectrum->rayleigh());
      return p.value();
    } else {
      return -1.0;
    }
  }

  double HRFKDirectRayleighVertical::value(const Point& kell) const
  {
    if(isInsideLimits(kell)) {
      FKSteeringThreeComponentRayleighVertical * s=static_cast<FKSteeringThreeComponentRayleighVertical *>(_steering);
      double ell=::tan(kell.z());
      s->initValue(kell, ell);
      FKPower p(s);
      p.setCaponValue(_crossSpectrum->rayleigh());
      return p.value();
    } else {
      return -1.0;
    }
  }

  double HRFKDirectRayleighVertical::ellipticity(const Point& kell)
  {
    double ell=::tan(kell.z());
    FKGridSearch grid;
    double ellh, ellz;
    ellz=ell;
    HRFKDirectRayleighRadialEllipticity * fh;
    fh=new HRFKDirectRayleighRadialEllipticity(_gridCache);
    grid.setFunction(fh);
    fh->setK(kell);
    grid.setGrid(kell.z()-M_PI/20, kell.z()+M_PI/20, M_PI/40);
    grid.globalMax(0.0);
    ellh=::tan(grid.pos().x());

    return ellipticityHelper(ellh, ellz);
  }

} // namespace ArrayCore

