/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKSTEERINGTWOCOMPONENTRAYLEIGHVERTICAL_H
#define FKSTEERINGTWOCOMPONENTRAYLEIGHVERTICAL_H

#include "FKSteering.h"
#include "FKCache.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKSteeringTwoComponentRayleighVertical : public FKSteering
  {
  public:
    FKSteeringTwoComponentRayleighVertical()
      : FKSteering() {}

    void resize() {FKSteering::resize(2*_array->count());}

    void initValue(const Point2D& k, double ell);

    static void init(FKCache * cache, int index, const Point& kell);

    static inline const FKSteeringTwoComponentRayleighVertical& cache(const FKCache * cache, int index);
    static inline FKSteeringTwoComponentRayleighVertical& cache(FKCache * cache, int index);
  };

  inline const FKSteeringTwoComponentRayleighVertical& FKSteeringTwoComponentRayleighVertical::cache(const FKCache * cache, int index)
  {
    return static_cast<const FKSteeringTwoComponentRayleighVertical&>(cache->steering(FKCache::TwoComponentRadial, index));
  }

  inline FKSteeringTwoComponentRayleighVertical& FKSteeringTwoComponentRayleighVertical::cache(FKCache * cache, int index)
  {
    return static_cast<FKSteeringTwoComponentRayleighVertical&>(cache->steering(FKCache::TwoComponentRadial, index));
  }

} // namespace ArrayCore

#endif // FKSTEERINGTWOCOMPONENTRAYLEIGHVERTICAL_H

