/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-04
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKSteering.h"

namespace ArrayCore {

  /*!
    \class FKSteering FKSteering.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing

    FKSteering is allocation in FKCache with new[], hence
    only default constructor is allowed.
  */
  FKSteering::FKSteering()
  {
    _array=nullptr;
    //_ell=0.0;
    _ell2=0.0;
  }

  /*!
    Description of destructor still missing
  */
  FKSteering::~FKSteering()
  {
  }

  void FKSteering::resize(int n)
  {
    _e.resize(n, 1);
    _eh.resize(1, n);

    /*_ehrx.resize(1, n);
    _ehry.resize(1, n);
    _ehrxrx.resize(1, n);
    _ehryry.resize(1, n);
    _ehrxry.resize(1, n);
    _rxe.resize(n, 1);
    _rye.resize(n, 1);*/
  }

  double FKSteering::dataSizeMb() const
  {
    return (2.0*_e.rowCount()+
            static_cast<double>(sizeof(double))
            +static_cast<double>(sizeof(Angle))
            +static_cast<double>(sizeof(ArraySelection *)))
        /(1024.0*1024.0);
    /*return ((9.0*_e.rowCount()+8.0*_t.rowCount())
        *static_cast<double>(sizeof(Complex))
            +20.0*static_cast<double>(sizeof(double))
            +static_cast<double>(sizeof(Angle))
            +static_cast<double>(sizeof(ArraySelection *)))
        /(1024.0*1024.0);*/
  }

} // namespace ArrayCore

