/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-09-17
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveHRFKRayleigh.h"
#include "FKGridSearch.h"
#include "FKCrossSpectrum.h"
#include "ActiveHRFKRayleighEllipticity.h"

namespace ArrayCore {

  /*!
    \class ActiveHRFKRayleigh ActiveHRFKRayleigh.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void ActiveHRFKRayleigh::setGrid(FKGridSearch * g, double step, double size)
  {
    g->setGrid(0.0, size, step, -0.5*M_PI, 0.5*M_PI, M_PI/20);
  }

  bool ActiveHRFKRayleigh::invertCrossSpectrum()
  {
    return _crossSpectrum->invertRayleigh();
  }

  double ActiveHRFKRayleigh::value(const Point& kell) const
  {
    double k2=kell.x()*kell.x();
    if(k2>minimumK2() && k2<maximumK2()) {
      //ComplexMatrix e, eh;
      //double ell=::tan(kell.y());
      //_steeringGeometry.twoComponentRayleighRadial(kell.x(), ell, e, eh);
      //double p=caponPower(eh, _crossSpectrum->rayleigh(), e);
      //return p*p*ell*ell;
    } else {
      return -1.0;
    }
  }

  double ActiveHRFKRayleigh::noise(const Point& kell) const
  {
    const ComplexMatrix& covmat=_crossSpectrum->rayleigh();
    FKGridSearch grid;
    ActiveHRFKRayleighVerticalEllipticity * fz;
    fz=new ActiveHRFKRayleighVerticalEllipticity(_gridCache);
    grid.setFunction(fz);
    fz->setK(kell.x());
    fz->setCrossSpectrum(&covmat);
    fz->setGrid(&grid, M_PI/20, 0.5*M_PI);
    grid.globalMax(0.0);
    double ez=::tan(grid.pos().x());
    ActiveHRFKRayleighRadialEllipticity * fh;
    fh=new ActiveHRFKRayleighRadialEllipticity(_gridCache);
    grid.setFunction(fh);
    fh->setK(kell.x());
    fh->setCrossSpectrum(&covmat);
    fh->setGrid(&grid, M_PI/20, 0.5*M_PI);
    grid.globalMax(0.0);
    double eh=::tan(grid.pos().x());
    return _crossSpectrum->stationCount()*(::sqrt(ez/eh)-1);
  }

} // namespace ArrayCore

