/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-09-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKTOOLSET_H
#define ACTIVEFKTOOLSET_H

#include "ArrayCoreDLLExport.h"
#include "ActiveFKParameters.h"

namespace ArrayCore {

  class ActiveFKTool;

  class ARRAYCORE_EXPORT ActiveFKToolSet : public AbstractTool
  {
  public:
    ActiveFKToolSet();
    ~ActiveFKToolSet();

    bool setSubPool(SubSignalPool * subPool);
    bool setParameters(const AbstractParameters& param);
    inline const ActiveFKParameters * parameters() const;
    inline ActiveFKParameters * parameters();

    const QList<ActiveFKTool *>& sources() const {return _subTools;}

    IrregularGrid2D grid(int index);
  protected:
    virtual QString toolName() {return tr("FK Array analysis for active sources");}
  public slots:
    virtual void start();
  private:
    QList<ActiveFKTool *> _subTools;
  };

  inline const ActiveFKParameters * ActiveFKToolSet::parameters() const
  {
    return static_cast<const ActiveFKParameters *>(AbstractTool::parameters());
  }

  inline ActiveFKParameters * ActiveFKToolSet::parameters()
  {
    return static_cast<ActiveFKParameters *>(AbstractTool::parameters());
  }

} // namespace ArrayCore

#endif // ACTIVEFKTOOLSET_H

