/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-09-17
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVECONVFKVERTICAL_H
#define ACTIVECONVFKVERTICAL_H

#include "ConvFKVertical.h"
#include "ArrayCoreDLLExport.h"
#include "ActiveFKSteering.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveConvFKVertical : public ConvFKVertical
  {
  public:
    ActiveConvFKVertical(FKCache * gridCache);

    virtual void setGrid(FKGridSearch * g, double step, double size);
    bool initGrid(int n);

    virtual bool setSource(const QVector<int>& blocks);

    virtual void addCrossSpectrum();

    virtual double value(const Point& k, int /*index*/) const {return value(k);}
    virtual double value(const Point& k) const;
  };

} // namespace ArrayCore

#endif // ACTIVECONVFKVERTICAL_H

